---
title: Restrict tokens · Cloudflare Fundamentals docs
description: "API tokens can be restricted at runtime in two ways:"
lastUpdated: 2024-12-16T22:33:26.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/api/how-to/restrict-tokens/
  md: https://developers.cloudflare.com/fundamentals/api/how-to/restrict-tokens/index.md
---

API tokens can be restricted at runtime in two ways:

* [Client IP address range filtering](#client-ip-address-range-filtering)
* [Time To Live (TTL) constraints](#time-to-live-ttl-constraints)

## Client IP address range filtering

Client IP address restrictions control which IP addresses can make API requests with this token. By default, if no filtering is applied, all IP addresses can use the token. Once an `Is in` rule is applied, the token can only be used from the defined IP addresses. Define ranges with [CIDR notation](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation). To allow an IP range with exceptions, define `Is not in` to exempt specific IPs or smaller ranges.

![IP Address filtering options](https://developers.cloudflare.com/_astro/ip-filter.DbEuurVj_Z29roa9.webp)

Note

Client IP address range filtering is not applied to the [Verify Token](https://developers.cloudflare.com/api/resources/user/subresources/tokens/methods/verify/) endpoint.

## Time to live (TTL) constraints

By default, tokens do not expire and are long lived. Defining a TTL sets when a token starts being valid and when a token is no longer valid. This is often referred to as `notBefore` and `notAfter`. Setting these timestamps limits the lifetime of the token to the defined period. Not setting the start date or `notBefore` means the token is active as soon as it is created. Not setting the end date or `notAfter` means the token does not expire.

Note

Dates selected are defined as 00:00 UTC of that day. For finer grained time selection, use the [API](https://developers.cloudflare.com/fundamentals/api/).

![Time to Live selection calendar](https://developers.cloudflare.com/_astro/ttl.6XWjuAt__1EwCH.webp)
