---
title: Resolve "you cannot modify this subscription" · Cloudflare Billing docs
description: 'This article will help if you are receiving an error that mentions
  "You cannot modify this subscription since it is currently scheduled to be
  cancelled" when attempting to cancel or modify a subscription. For reference,
  the full message you receive may be one of the following:'
lastUpdated: 2025-08-21T17:26:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/resolve-you-cannot-modify-this-subscription/
  md: https://developers.cloudflare.com/billing/resolve-you-cannot-modify-this-subscription/index.md
---

This article will help if you are receiving an error that mentions "You cannot modify this subscription since it is currently scheduled to be cancelled" when attempting to cancel or modify a subscription. For reference, the full message you receive may be one of the following:

* "failed in ActionAppendSubscription: failed to update user subscription: failed to apply object products: You cannot modify this subscription since is currently scheduled to be canceled at the end of your current billing period. In order to purchase more of the service, you will need to click the Cancel Downgrade button on the Subscriptions page in the Billing section."
* "failed in ActionAppendSubscription: failed to apply object products: You cannot modify this subscription since is currently scheduled to be canceled at the end of your current billing period. In order to purchase more of the service, you will need to click the Cancel Downgrade button on the Subscriptions page in the Billing section."

## Causes

* You are attempting to cancel a subscription which you have already requested cancellation for
* You are attempting to upgrade a subscription for which a cancellation is already scheduled

## Solutions

If your intent is to cancel a subscription, this request has already been scheduled and your subscription will be cancelled at the end of the current billing period. See “When will my subscription be cancelled” below to understand the exact date this will take effect.

### When will my subscription be cancelled?

Once you have requested cancellation, you will see the date your subscription will be cancelled on the subscriptions page underneath the text “Ending On”.

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Manage Account > Billing**.
3. Go to **Subscriptions**.
4. Locate the **Product** you have cancelled
5. Under the **Service status** column, the status should say **ENDING ON** with the date cancellation will take effect

If you previously cancelled the subscription and have changed your decision, you need to cancel the downgrade.

### Can I receive a refund for my cancelled subscription?

No refund will be issued for a cancelled subscription - instead, your subscription will remain active until the end of the current billing period.

If you do not wish to pay for the coming billing period, then you should cancel your subscription no later than on the last day of the billing period. You can discover this date by visiting the **Subscriptions** page and checking the renew date, for example “RENEWS ON Aug 29, 2025”.

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Manage Account > Billing**.
3. Go to **Subscriptions**.
4. Locate the **Product** you have cancelled
5. Under the **Service status** column, the status should say **RENEWS ON** with the date of the next renewal

### Can I stop the cancellation?

If the cancellation hasn’t taken effect yet, you can click **Cancel Downgrade** next to the appropriate subscription in the **Billing > Subscriptions** page.

1. Log into the [Cloudflare dashboard](https://dash.cloudflare.com) and select your account.
2. Go to **Manage Account > Billing**.
3. Go to **Subscriptions**.
4. Locate the **Product** you have cancelled
5. Under the **Action** column, click **Cancel Downgrade**
